//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.ui.components](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [ActionSheetState](-action-sheet-state/index.md) | [common]<br>abstract class [ActionSheetState](-action-sheet-state/index.md)(sheetState: [ModalBottomSheetState](https://developer.android.com/reference/kotlin/androidx/compose/material/ModalBottomSheetState.html)) |
| [AvatarDefaults](-avatar-defaults/index.md) | [common]<br>object [AvatarDefaults](-avatar-defaults/index.md)<br>Defaults for the Avatar component |
| [AvatarSize](-avatar-size/index.md) | [common]<br>interface [AvatarSize](-avatar-size/index.md)<br>Size constraint system for rendering the avatar component |
| [AvatarType](-avatar-type/index.md) | [common]<br>interface [AvatarType](-avatar-type/index.md)<br>Type definition for a given [Avatar](-avatar.md) instance |
| [HeaderDefaults](-header-defaults/index.md) | [common]<br>object [HeaderDefaults](-header-defaults/index.md)<br>Default constraints and actions for [Header](-header.md) provided as convenience. These each come with preset styling. |
| [HeaderState](-header-state/index.md) | [common]<br>class [HeaderState](-header-state/index.md)(val showSearch: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, val showSearchClear: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, isSearchActive: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>HeaderState |
| [MediaActionSheetState](-media-action-sheet-state/index.md) | [common]<br>class [MediaActionSheetState](-media-action-sheet-state/index.md)(chat: [Chat](../ai.botstacks.sdk.state/-chat/index.md), sheetState: [ModalBottomSheetState](https://developer.android.com/reference/kotlin/androidx/compose/material/ModalBottomSheetState.html)) : [ActionSheetState](-action-sheet-state/index.md)<br>MediaActionSheetState |
| [MessageActionSheetState](-message-action-sheet-state/index.md) | [common]<br>class [MessageActionSheetState](-message-action-sheet-state/index.md)(sheetState: [ModalBottomSheetState](https://developer.android.com/reference/kotlin/androidx/compose/material/ModalBottomSheetState.html)) : [ActionSheetState](-action-sheet-state/index.md)<br>MediaActionSheetState |
| [OverflowMenuScope](-overflow-menu-scope/index.md) | [common]<br>interface [OverflowMenuScope](-overflow-menu-scope/index.md)<br>Interface that an OverflowMenu renders items based upon. This is utilized in [Header](-header.md) for the Header.menu. |

## Functions

| Name | Summary |
|---|---|
| [_Badge](_-badge.md) | [ios]<br>fun [_Badge](_-badge.md)(count: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): UIViewController |
| [Avatar](-avatar.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Avatar](-avatar.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, size: [AvatarSize](-avatar-size/index.md) = AvatarDefaults.Size, status: [OnlineStatus](../ai.botstacks.sdk.state/-online-status/index.md) = OnlineStatus.Unknown, url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, chat: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Avatar](-avatar.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, size: [AvatarSize](-avatar-size/index.md) = AvatarDefaults.Size, user: [User](../ai.botstacks.sdk.state/-user/index.md), showOnlineStatus: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = true, isSelected: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, isRemovable: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Avatar](-avatar.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, backgroundColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = AvatarDefaults.BackgroundColor, contentColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = AvatarDefaults.ContentColor, size: [AvatarSize](-avatar-size/index.md) = AvatarDefaults.Size, type: [AvatarType](-avatar-type/index.md), isSelected: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, isRemovable: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false)<br>Avatar |
| [Badge](-badge.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Badge](-badge.md)(count: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html), modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier)<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Badge](-badge.md)(label: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier)<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Badge](-badge.md)(label: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, backgroundColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.primary, contentColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.onPrimary, contentPadding: [PaddingValues](https://developer.android.com/reference/kotlin/androidx/compose/foundation/layout/PaddingValues.html) = PaddingValues(         horizontal = BotStacks.dimens.grid.x2,         vertical = BotStacks.dimens.grid.x1     ), fontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.caption2, shape: [Shape](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Shape.html) = CircleShape)<br>Badge |
| [ChannelGroup](-channel-group.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [ChannelGroup](-channel-group.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, channels: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Chat](../ai.botstacks.sdk.state/-chat/index.md)&gt;)<br>ChannelGroup |
| [ChannelRow](-channel-row.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [ChannelRow](-channel-row.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, chat: [Chat](../ai.botstacks.sdk.state/-chat/index.md), showMemberPreview: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, titleFontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.body1, titleColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.onBackground, subtitleFontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.body1, subtitleColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.caption, onClick: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { })<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [ChannelRow](-channel-row.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html), imageUrls: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?&gt;, title: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), titleFontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.body1, titleColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.onBackground, subtitle: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)? = null, subtitleFontStyle: [FontStyle](../ai.botstacks.sdk.ui.theme/-font-style/index.md) = BotStacks.fonts.body1, subtitleColor: [Color](https://developer.android.com/reference/kotlin/androidx/compose/ui/graphics/Color.html) = BotStacks.colorScheme.caption, onClick: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>ChannelRow |
| [ChatInput](-chat-input.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [ChatInput](-chat-input.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, chat: [Chat](../ai.botstacks.sdk.state/-chat/index.md), onMedia: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), focusRequester: [FocusRequester](https://developer.android.com/reference/kotlin/androidx/compose/ui/focus/FocusRequester.html) = remember { FocusRequester() })<br>ChatInput |
| [ChatList](-chat-list.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [ChatList](-chat-list.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, header: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }, emptyState: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { EmptyListView(config = BotStacks.assets.emptyChats)  }, filter: ([Chat](../ai.botstacks.sdk.state/-chat/index.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = { true }, onChatClicked: ([Chat](../ai.botstacks.sdk.state/-chat/index.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>ChatList |
| [ChatMessage](-chat-message.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [ChatMessage](-chat-message.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, message: [Message](../ai.botstacks.sdk.state/-message/index.md), shape: [CornerBasedShape](https://developer.android.com/reference/kotlin/androidx/compose/foundation/shape/CornerBasedShape.html) = shapes.medium, showAvatar: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, showTimestamp: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = true, onPressUser: ([User](../ai.botstacks.sdk.state/-user/index.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), onLongPress: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), onClick: ([MessageAttachment](../ai.botstacks.sdk.state/-message-attachment/index.md)?) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null)<br>ChatMessage |
| [ChatMessagePreview](-chat-message-preview.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [ChatMessagePreview](-chat-message-preview.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, chat: [Chat](../ai.botstacks.sdk.state/-chat/index.md), onClick: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>ChatMessagePreview |
| [Header](-header.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Header](-header.md)()<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Header](-header.md)(title: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }, icon: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }, state: [HeaderState](-header-state/index.md) = rememberHeaderState(), onSearchClick: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, onAdd: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, onCompose: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, onBackClicked: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, menu: [OverflowMenuScope](-overflow-menu-scope/index.md).() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, endAction: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { })<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Header](-header.md)(title: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), icon: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }, state: [HeaderState](-header-state/index.md) = rememberHeaderState(), onSearchClick: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, onAdd: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, onCompose: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, onBackClicked: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, menu: [OverflowMenuScope](-overflow-menu-scope/index.md).() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html)? = null, endAction: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { })<br>Header |
| [MediaActionSheet](-media-action-sheet.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [MediaActionSheet](-media-action-sheet.md)(state: [MediaActionSheetState](-media-action-sheet-state/index.md), content: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>MediaActionSheet |
| [MessageActionSheet](-message-action-sheet.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [MessageActionSheet](-message-action-sheet.md)(state: [MessageActionSheetState](-message-action-sheet-state/index.md) = rememberMessageActionSheetState(), content: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>MessageActionSheet |
| [MessageList](-message-list.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [MessageList](-message-list.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, chat: [Chat](../ai.botstacks.sdk.state/-chat/index.md), header: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }, emptyState: @[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)() -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { EmptyListView(config = assets.emptyChat) }, onPressUser: ([User](../ai.botstacks.sdk.state/-user/index.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html), onLongPress: ([Message](../ai.botstacks.sdk.state/-message/index.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html))<br>MessageList |
| [rememberHeaderState](remember-header-state.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [rememberHeaderState](remember-header-state.md)(isSearchVisible: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, isSearchActive: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, showSearchClear: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false): [HeaderState](-header-state/index.md)<br>Creates a [HeaderState](-header-state/index.md) and remembers it. |
| [rememberMediaActionSheetState](remember-media-action-sheet-state.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [rememberMediaActionSheetState](remember-media-action-sheet-state.md)(chat: [Chat](../ai.botstacks.sdk.state/-chat/index.md)): [MediaActionSheetState](-media-action-sheet-state/index.md)<br>Creates a [MediaActionSheetState](-media-action-sheet-state/index.md) and remembers it. |
| [rememberMessageActionSheetState](remember-message-action-sheet-state.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [rememberMessageActionSheetState](remember-message-action-sheet-state.md)(message: [Message](../ai.botstacks.sdk.state/-message/index.md)? = null): [MessageActionSheetState](-message-action-sheet-state/index.md)<br>Creates a [MessageActionSheetState](-message-action-sheet-state/index.md) and remembers it. |
| [Spinner](-spinner.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [Spinner](-spinner.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier)<br>Spinner |
| [UserProfile](-user-profile.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [UserProfile](-user-profile.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, user: [User](../ai.botstacks.sdk.state/-user/index.md))<br>UserProfile |
| [UserSelect](-user-select.md) | [common]<br>@[Composable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Composable.html)<br>fun [UserSelect](-user-select.md)(modifier: [Modifier](https://developer.android.com/reference/kotlin/androidx/compose/ui/Modifier.html) = Modifier, selectedUsers: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[User](../ai.botstacks.sdk.state/-user/index.md)&gt;, canRemove: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = false, showAdd: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) = true, onRemove: ([User](../ai.botstacks.sdk.state/-user/index.md)) -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { }, onAddSelected: () -&gt; [Unit](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-unit/index.html) = { })<br>UserSelect |
